/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.storage.externalstorage;

import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.apiimpl.API;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class ItemExternalStorageCache {
    private List<ItemStack> cache;
    private int stored = 0;

    public int getStored() {
        return this.stored;
    }

    public void update(INetwork network, @Nullable IItemHandler handler) {
        int i;
        if (handler == null) {
            this.stored = 0;
            return;
        }
        if (this.cache == null) {
            this.cache = new ArrayList<ItemStack>();
            int stored = 0;
            for (int i2 = 0; i2 < handler.getSlots(); ++i2) {
                ItemStack stack = handler.getStackInSlot(i2).m_41777_();
                this.cache.add(stack);
                stored += stack.m_41613_();
            }
            this.stored = stored;
            return;
        }
        int stored = 0;
        for (i = 0; i < handler.getSlots(); ++i) {
            ItemStack actual = handler.getStackInSlot(i);
            stored += actual.m_41613_();
            if (i >= this.cache.size()) {
                if (actual.m_41619_()) continue;
                network.getItemStorageCache().add(actual, actual.m_41613_(), false, true);
                this.cache.add(actual.m_41777_());
                continue;
            }
            ItemStack cached = this.cache.get(i);
            if (!cached.m_41619_() && actual.m_41619_()) {
                network.getItemStorageCache().remove(cached, cached.m_41613_(), true);
                this.cache.set(i, ItemStack.f_41583_);
                continue;
            }
            if (cached.m_41619_() && !actual.m_41619_()) {
                network.getItemStorageCache().add(actual, actual.m_41613_(), false, true);
                this.cache.set(i, actual.m_41777_());
                continue;
            }
            if (!API.instance().getComparer().isEqualNoQuantity(cached, actual)) {
                network.getItemStorageCache().remove(cached, cached.m_41613_(), true);
                network.getItemStorageCache().add(actual, actual.m_41613_(), false, true);
                this.cache.set(i, actual.m_41777_());
                continue;
            }
            if (cached.m_41613_() == actual.m_41613_()) continue;
            int delta = actual.m_41613_() - cached.m_41613_();
            if (delta > 0) {
                network.getItemStorageCache().add(actual, delta, false, true);
                cached.m_41769_(delta);
                continue;
            }
            network.getItemStorageCache().remove(actual, Math.abs(delta), true);
            cached.m_41774_(Math.abs(delta));
        }
        this.stored = stored;
        if (this.cache.size() > handler.getSlots()) {
            for (i = this.cache.size() - 1; i >= handler.getSlots(); --i) {
                ItemStack cached = this.cache.get(i);
                if (!cached.m_41619_()) {
                    network.getItemStorageCache().remove(cached, cached.m_41613_(), true);
                }
                this.cache.remove(i);
            }
        }
        network.getItemStorageCache().flush();
    }
}

